import { i18n } from 'lib/i18n';
import getErrorMap from './getErrorMap';

const paymentValidator = {

    getAmountError(data) {
        if (typeof data.amount === 'string') {
            if (!data.amount) {
                return i18n('subscription_validation.payment.amount_undefined');
            }

            data.amount = Number(data.amount);
        }

        if (Number.isNaN(data.amount)) {
            return i18n('subscription_validation.payment.invalid_amount');
        }

        if (data.amount <= 0) {
            return i18n('subscription_validation.payment.non-positive_amount');
        }

        return null;
    },

};

paymentValidator.getErrors = getErrorMap(paymentValidator);

export default paymentValidator;
