Конфигурация портала основывается на [принципах 12-факторного приложения](https://habrahabr.ru/post/261171/) ([более развёрнуто](https://habrahabr.ru/post/258739/)). Это означает, что портал не содержит в себе знания о конечной конфиругации приложения и собирается в 1 пакет (в отличие, например, от ямба, или почты).

Конфигурирование имеет несколько уровней:

1. base.js
2. Переменные окружения
3. Переменные окружения процесса
4. local.js

Все эти уровни мержатся во время запуска приложения, в результате получается конечная конфигурация. Приоритет идёт от 1 до 4: то есть, если один и тот же ключ есть во всех уровнях, то в конечную конфигурацию попадёт значение из local.js.

Сама по себе конфигурация является js-объектом одного уровня вложенности. В серверном коде конфиг доступен через `server/config`, а в клиентском через `client/config`. Важно понимать, что первоисточником является `server/config`, тогда как клиентский конфиг это просто (изначально пустая) backbone-модель, которая заполняется данными из `server/config`, переданными в теле html страницы.

Клиентский и серверный конфиги сейчас полностью совпадают. При этом **нельзя забывать** в различии обращения к ключам:

```js
# server
config.logLevel;

# client
config.get('logLevel');
```

## base.js

Базовый конфиг, который, по сути, нужен для минимальной работоспособности портала и задания дефолтных значений.

## Переменные окружения

Переменные, любым способом заданные в окружении, в котором запускается процесс. В облаках qloud это (задание и изменение переменных) делается через web-интерфейс. Все переменные начинаются с префикса `PORTAL`, именуются в uppercase, разделителем является символ `_`. При чтении переменных окружения они переводятся в обычный camelCase без префикса. Например:

```bash
# Переменная окружения
PORTAL_URL_DIRECTORY
# соответствует ключу конфига
urlDirectory
```

## Переменные окружения процесса

То же что и переменные окружения, но которые можно задать непосредственно при запуске процесса. С их помощью можно переопределить нужные ключи. Например:

```bash
PORTAL_URL_DIRECTORY=http://example.com node server/
```

## local.js

Файл, который можно поместить рядом с `base.js`, и переопределить все другие уровни конфигурирования. Файл находится под `.gitignore`, и фактически нужен для локальной настройки дев-окружения и своей организации. Например:

```js
module.exports = {
    socket: false,
    port: 3000,
    cert: '/Users/diokuz/portal/server/dev.crt',
    groupLabelDisabled: 'true',

    // diokuz
    passport: {
        currentUser: {
            uid: '1130000000192411',
            domain: 'dima2.ws.yandex.ru',
            login: 'diokuz@dima2.ws.yandex.ru',
            hasPassword: true,
            'display_name': 'diokuz@dima2.ws.yandex.ru',
            sids: [2],
            locale: 'ru',
            country: 'ru'
        },
        auth: {
            Authorization: 'Token sJdopXTghCwMfPLxRFjy8YcbNvDAIGr',
            'x-uid': '1130000000192411',
            'x-user-ip': '2a02:6b8:0:107:640a:1f9e:be70:20c6'
        }
    }
};

```

Обрати внимание на ключ `passport` – он нужен для обхода паспорта. Если ключ есть, портал не будет ходить в паспорт, а воспользуется моком его ответа.
