const _get = require('lodash/get');
const APIClient = require('../lib2/APIClient');
const getBasicRequestHeaders = require('../lib2/getBasicRequestHeaders');

module.exports = function directory(req, additionalHeaders) {
    let headers = {
        ...getBasicRequestHeaders(req),
        'X-Ya-Service-Ticket': _get(req, 'tvm.tickets.directory.ticket'),
        'X-Ya-User-Ticket': req.blackbox.userTicket,
        // @see DIR-1962
        'x-debug': req.get('x-debug') || (req.query && req.query.debug),
        // @see DIR-2533
        'x-database': req.get('x-first-visit') && 'master',
        ...additionalHeaders,
    };

    if (headers['x-debug'] === undefined) {
        delete headers['x-debug'];
    }

    if (headers['x-database'] === undefined) {
        delete headers['x-database'];
    }

    return new APIClient(req, _get(req, 'config.api.directory'), headers);
};
