const _get = require('lodash/get');
const APIClient = require('../lib2/APIClient');
const getBasicRequestHeaders = require('../lib2/getBasicRequestHeaders');

module.exports = function dns(req) {
    return new APIClient(req, _get(req, 'config.api.dns'), {
        ...getBasicRequestHeaders(req),
        'X-Ya-Service-Ticket': _get(req, 'tvm.tickets.dns.ticket'),
        'X-Ya-User-Ticket': req.blackbox.userTicket,
    });
};
