const _get = require('lodash/get');
const APIClient = require('../lib2/APIClient');
const getBasicRequestHeaders = require('../lib2/getBasicRequestHeaders');

module.exports = function sender(req) {
    let user = _get(req, 'config.tokens.sender');
    let password = '';

    return new APIClient(req, _get(req, 'config.api.sender'), {
        ...getBasicRequestHeaders(req),
        Authorization: `Basic ${Buffer.from(`${user}:${password}`).toString('base64')}`,
    });
};
