module.exports = {
    api: {
        ya: 'https://yandex.com',
    },
    app: {
        changeLanguage: 'https://www.yandex.com/portal/set/lang/?intl=${intl}&retpath=${retpath}&sk=${sk}',
    },
    ui: {
        serviceActions: {
            mail: 'http://mail.yandex.com/compose',
            disk: 'https://disk.yandex.com/client/disk',
            yamb: 'https://yandex.com/chat',
            wiki: 'https://wiki.yandex.com/homepage/.create',
            forms: 'https://forms.yandex.com/admin/myforms/drafts',
            calendar: 'https://calendar.yandex.com/event?uid=521963284',
            tracker: 'https://tracker.yandex.com/createTicket',
            webmaster: '/portal/services/webmaster#add-domain',
            direct: 'https://direct.yandex.com/dna/welcome/',
            portal: '/portal/admin#add-user',
            staff: 'https://staff.yandex.com/?org_id=${org_id}&uid=${uid}',
        },
        relatedServices: {
            webmaster: 'https://webmaster.yandex.com/sites/?noRedirect=yes&utm_source=connect&utm_content=dash&utm_term=webmaster', // eslint-disable-line max-len
            metrika: 'https://metrika.yandex.com',
            direct: 'https://direct.yandex.com',
            calendar: 'https://calendar.yandex.com',
            contacts: 'https://mail.yandex.com/#contacts',
            disk: 'https://disk.yandex.com',
            mail: 'https://mail.yandex.com/?uid=${uid}',
            passport: 'https://passport.yandex.com',
            wiki: 'https://wiki.yandex.com',
            forms: 'https://forms.yandex.com/b2b/admin/',
            tracker: 'https://tracker.yandex.com',
            yamb: 'https://yandex.com/chat',
            browser: 'https://browser.yandex.com/constructor/?utm_source=connect&utm_medium=home',
        },
        relatedApps: {
            yamb: {
                android: 'https://play.google.com/store/apps/details?id=com.yandex.yamb',
                ios: 'https://itunes.apple.com/ru/app/amb/id1124487701?mt=8',
                pc: 'https://yamb.yandex.com/desktop/download/?platform=${platform}',
            },
            mail: {
                android: 'https://play.google.com/store/apps/details?id=ru.yandex.mail',
                ios: 'https://itunes.apple.com/ru/app/yandex.mail/id441785419',
            },
            disk: {
                android: 'https://play.google.com/store/apps/details?id=ru.yandex.disk',
                ios: 'https://itunes.apple.com/ru/app/andeks.disk/id553266487',
                pc: 'https://disk.yandex.com/download/#pc',
            },
            browser: {
                pc: 'https://browser.yandex.com/constructor/?utm_source=connect&utm_medium=home',
            },
        },
        help: {
            dkim: 'https://yandex.com/support/connect/dns/dkim.html',
            domains: 'https://yandex.com/support/connect/domains.html',
            domain_confirmation: 'https://yandex.com/support/domain/setting/confirm.html',
            wiki: {
                details: 'https://yandex.com/support/connect-wiki/index.html',
            },
            tracker: {
                details: 'https://connect.yandex.com/tracker?noredirect=1',
                pricing: 'https://connect.yandex.com/pricing/tracker?noredirect',
            },
            subscription: {
                default: 'https://connect.yandex.com/pricing',
            },
            offer: 'https://yandex.ru/legal/oferta_connect/?lang=en',
            bind: {
                advantages: {
                    // Метрики пока нет на .com
                    metrika: 'http://connect.yandex.ru/metrika?noredirect=1&utm_source=metrica&utm_medium=interface&utm_campaign=yaconnect&utm_content=widget_link', // eslint-disable-line max-len
                },
                more: {
                    // Метрики пока нет на .com
                    metrika: 'http://connect.yandex.ru/metrika?noredirect=1&utm_source=metrica&utm_medium=interface&utm_campaign=yaconnect&utm_content=widget_beta', // eslint-disable-line max-len
                },
            },
            user_agreement: 'https://yandex.com/legal/rules/',
            privacy_policy: 'https://yandex.com/legal/confidential/',
            license_agreement: 'https://yandex.ru/legal/connect_software_agreement/?lang=en',
            service_request: 'https://forms.yandex.com/surveys/5455/',
            troubleshooting: 'https://yandex.com/support/connect/troubleshooting.html',
            feedback: 'https://yandex.com/support/connect/troubleshooting.html#troubleshooting__feedback',
            dns_editor: 'https://yandex.com/support/connect/dns-editor.html',
            delegate_domain: 'https://yandex.com/support/connect/delegate-domain.html',
            mx: 'https://yandex.com/support/connect/dns/mx.html',

            reorg: 'https://yandex.com/support/connect/reorg.html',
            metricsTagAccess: 'https://yandex.com/support/connect/metrics.html#metrica__tag-access',
            metricsDetachTag: 'https://yandex.com/support/connect/metrics.html#metrica__detach-tag',
            metrikaGeneralAccess: 'https://yandex.com/support/metrica/general/access.html',
        },
        cloud: {
            org: 'https://org-preprod.cloud.yandex.com/',
            orgCreate: 'https://org-preprod.cloud.yandex.com/create',
            promo: {
                // wiki: 'https://cloud.yandex.com/services/wiki',
                // forms: 'https://cloud.yandex.com/services/forms',
                tracker: 'https://cloud.yandex.com/services/tracker',
            },
        },
        metrika_counters: 'https://metrika.yandex.com/list',
        email: 'https://mail.yandex.com/compose?to=${email}',
        privateYambChat: 'https://api.messenger.yandex.com/user/${nickname}',
        staff: 'https://staff.yandex.com/${nickname}?org_id=${org_id}&uid=${uid}',
        pdd: 'https://domain.yandex.com/',
        promo: 'https://yandex.com/ws/',
        rootPage: 'https://yandex.com/',
    },
    landing: {
        tracker: 'https://yandex.com/tracker/',
        forms: 'https://yandex.com/forms/',
    },
    passport: {
        session: {
            login: 'https://passport.yandex.com/auth?retpath=${retpath}',
            logout: 'https://passport.yandex.com/passport?mode=embeddedauth&action=logout&uid=${uid}&yu=${yu}&retpath=${retpath}', // eslint-disable-line max-len
            change: 'https://passport.yandex.com/passport?mode=embeddedauth&action=change_default&uid=${uid}&yu=${yu}&retpath=${retpath}', // eslint-disable-line max-len
            add: 'https://passport.yandex.com/auth?mode=add-user&retpath=${retpath}',
            update: 'https://passport.yandex.com/auth/update/?retpath=${retpath}',
            passwordChange: 'https://passport.yandex.com/passport?mode=changepass&retpath=${retpath}',
            confirmEmail: 'https://passport.yandex.com/passport?mode=changeemails',
            approveUser: 'https://passport.yandex.com/passport?mode=userapprove&retpath=${retpath}',
        },
    },
    mail: {
        mail: 'https://mail.yandex.com',
        admin: 'https://admin.yandex.ru/mail?org_id=${org_id}&uid=${uid}',
    },
};
