module.exports = {
    ui: {
        relatedServices: {
            calendar: 'https://calendar.yandex-team.com',
            contacts: 'https://mail.yandex-team.com/#contacts',
            disk: 'https://disk.yandex.com',
            mail: 'https://mail.yandex-team.com/?uid=${uid}',
            passport: 'https://passport.yandex-team.com',
            wiki: 'https://wiki.yandex-team.com',
            yamb: 'https://q.yandex-team.ru',
        },
        avatar: {
            url: 'https://q.yandex-team.ru/avatar/${login}/${size}.jpg',
        },
        email: 'https://mail.yandex-team.com/compose?to=${email}',
        privateYambChat: 'https://yamb.yandex-team.com/user/${nickname}',
        staff: 'https://staff.yandex-team.com/${nickname}?org_id=${org_id}&uid=${uid}',
    },
    passport: {
        session: {
            login: 'https://passport.yandex-team.com/auth?retpath=${retpath}',
            logout: 'https://passport.yandex-team.com/passport?mode=embeddedauth&action=logout&uid=${uid}&yu=${yu}&retpath=${retpath}', // eslint-disable-line max-len
            change: 'https://passport.yandex-team.com/passport?mode=embeddedauth&action=change_default&uid=${uid}&yu=${yu}&retpath=${retpath}', // eslint-disable-line max-len
            add: 'https://passport.yandex-team.com/auth?mode=add-user&retpath=${retpath}',
            update: 'https://passport.yandex-team.com/auth/update/?retpath=${retpath}',
            passwordChange: 'https://passport.yandex-team.com/passport?mode=changepass&retpath=${retpath}',
        },
    },
    metrika: {
        default: 37737870,
    },
    csp: {
        extra: {
            'img-src': 'yamb.yandex-team.com yamb.yandex-team.ru',
        },
    },
};
