module.exports = {
    api: {
        tvm: 'https://connect-test.ws.yandex.com/auth',
    },
    app: {
        root: '/',
    },
    ui: {
        avatar: {
            url: 'https://yapic-test.yandex.ru/get/${id}/islands-${size}',
        },
        serviceActions: {
            wiki: 'https://wiki.test.yandex.com/homepage/.create',
            forms: 'https://forms.test.yandex.com/admin/myforms/drafts',
            tracker: 'https://tracker.test.yandex.com/createTicket',
        },
        relatedServices: {
            calendar: 'https://calendar.yandex.com',
            contacts: 'https://mail.yandex.com/#contacts',
            disk: 'https://disk.yandex.com',
            mail: 'https://mail.yandex.com/?uid=${uid}',
            passport: 'https://passport-test.yandex.com',
            wiki: 'https://wiki.test.yandex.com',
            forms: 'https://forms.test.yandex.com/b2b/admin/',
            yamb: 'https://yamb-test.ws.yandex.com',
        },
        help: {
            bind: {
                advantages: {
                    default: 'http://connect-test.ws.yandex.com/faq?noredirect=1',
                    // Метрики пока нет на .com
                    metrika: 'http://connect-test.ws.yandex.ru/metrika?noredirect=1&utm_source=metrica&utm_medium=interface&utm_campaign=yaconnect&utm_content=widget_link', // eslint-disable-line max-len
                },
                more: {
                    default: 'http://connect-test.ws.yandex.com/faq?noredirect=1',
                    // Метрики пока нет на .com
                    metrika: 'http://connect-test.ws.yandex.ru/metrika?noredirect=1&utm_source=metrica&utm_medium=interface&utm_campaign=yaconnect&utm_content=widget_beta', // eslint-disable-line max-len
                },
                faq: {
                    default: 'https://connect-test.ws.yandex.com/faq?noredirect=1',
                },
            },
        },
        privateYambChat: 'https://yamb-test.ws.yandex.com/user/${nickname}',
        staff: 'https://team.test.yandex.com/${nickname}?org_id=${org_id}&uid=${uid}',
    },
    passport: {
        session: {
            login: 'https://passport-test.yandex.com/auth?retpath=${retpath}',
            logout: 'https://passport-test.yandex.com/passport?mode=embeddedauth&action=logout&uid=${uid}&yu=${yu}&retpath=${retpath}', // eslint-disable-line max-len
            change: 'https://passport-test.yandex.com/passport?mode=embeddedauth&action=change_default&uid=${uid}&yu=${yu}&retpath=${retpath}', // eslint-disable-line max-len
            add: 'https://passport-test.yandex.com/auth?mode=add-user&retpath=${retpath}',
            update: 'https://passport-test.yandex.com/auth/update/?retpath=${retpath}',
            passwordChange: 'https://passport-test.yandex.com/passport?mode=changepass&retpath=${retpath}',
            confirmEmail: 'https://passport-test.yandex.ru/passport?mode=changeemails',
            approveUser: 'https://passport-test.yandex.com/passport?mode=userapprove&retpath=${retpath}',
        },
    },
    metrika: {
        default: 37738550,
    },
};
