/* eslint-disable max-len */

const { URL } = require('url');

function getTvmApi() {
    return new URL('/tvm',
        process.env.DEPLOY_TVM_TOOL_URL ||
        process.env.QLOUD_TVM_INTERFACE_ORIGIN ||
        'http://localhost:1'
    ).href;
}

module.exports = {
    server: {
        port: 80,
        cert: '/app/YandexInternalRootCA.crt',
    },
    app: {
        root: '/portal/',
        assets: '//yastatic.net/s3/frontend/${app.name}/v${app.version}',
        freezePath: '//yastatic.net/s3/frontend/${app.name}/_',
        logLevel: 'info',
        changeLanguage: 'https://www.yandex.ru/portal/set/lang/?intl=${intl}&retpath=${retpath}&sk=${sk}',
        acceptedLocales: [
            'ru',
            'en',
            'tr',
        ],
        qloudEnv: process.env.QLOUD_ENVIRONMENT || '',
    },
    bunker: {
        project: 'connect',
        api: 'http://bunker-api.yandex.net/v1',
        version: 'stable',
        updateInterval: 0,
    },
    tokens: {
        auth: '',
        settings: '',
        sender: '',
    },
    api: {
        app: {
            default: '/api',
            service: '/serviceapi',
            suggest: '/suggest/?${query}',
        },
        ya: 'https://yandex.ru',
        blackbox: 'https://blackbox.yandex.net/blackbox',
        tvm: getTvmApi(),
        directory: 'https://api-internal.directory.ws.yandex.net',
        gendarme: 'https://gendarme.mail.yandex.net',
        dns: 'https://prod.dns-hosting.ws.yandex.net/api/v1',
        setter: 'https://setter.mail.yandex.net',
        fouras: 'https://fouras.mail.yandex.net',
        settings: 'https://settings.ws.yandex.ru',
        sender: 'https://sender.yandex-team.ru',
    },
    directory: {
        perPage: {
            default: 100,
            groups: 100,
        },
    },
    rum: {
        service_id: 'ru.connect.portal.external',
        project_id: 'connect',
        counter_url: '',
    },
    ui: {
        serviceActions: {
            mail: 'https://mail.yandex.ru/compose',
            disk: '/portal/services/disk#add-subscription',
            yamb: 'https://yandex.ru/chat',
            wiki: 'https://wiki.yandex.ru/homepage/.create',
            forms: 'https://forms.yandex.ru/admin/myforms/drafts',
            calendar: 'https://calendar.yandex.ru/event?uid=521963284',
            tracker: 'https://tracker.yandex.ru/createTicket',
            webmaster: '/portal/services/webmaster#add-domain',
            direct: 'https://direct.yandex.ru/dna/welcome/',
            portal: '/portal/admin#add-user',
            staff: 'https://staff.yandex.ru/${nickname}?org_id=${org_id}&uid=${uid}',
            browser: 'https://browser.yandex.ru/constructor/?tableauPreset=connect',
        },

        serviceSettings: {
            disk: 'https://admin.yandex.ru/disk?org_id=${org_id}&uid=${uid}',
        },

        serviceTabLink: {
            tracker: 'https://tracker.yandex.${tld}/admin/',
        },

        relatedServices: {
            staff: '~/staff',
            webmaster: 'https://webmaster.yandex.ru/sites/?noRedirect=yes&utm_source=connect&utm_content=dash&utm_term=webmaster',
            metrika: 'https://metrika.yandex.ru',
            direct: 'https://direct.yandex.ru',
            calendar: 'https://calendar.yandex.ru',
            contacts: 'https://mail.yandex.ru/#contacts',
            passport: 'https://passport.yandex.ru',
            mail: 'https://mail.yandex.ru/?uid=${uid}',
            wiki: 'https://wiki.yandex.ru',
            tracker: 'https://tracker.yandex.ru',
            disk: 'https://disk.yandex.ru',
            yamb: 'https://yandex.ru/chat',
            yandex: 'https://yandex.ru',
            forms: 'https://forms.yandex.ru/b2b/admin/',
            yandexsprav: 'https://yandex.ru/sprav/',
            alice_b2b: 'https://dialogs.yandex.ru/b2b',
            browser: 'https://browser.yandex.ru/corp/?tableauPreset=connect',
        },

        relatedResources: {
            metrika: 'https://metrika.yandex.${tld}/dashboard?id=${id}',
            yandexsprav: 'https://yandex.${tld}/sprav/search?permalink=${id}',
            alice_b2b: 'https://dialogs.yandex.ru/b2b/devices/${id}',
        },

        relatedApps: {
            yamb: {
                android: 'https://play.google.com/store/apps/details?id=com.yandex.yamb',
                ios: 'https://itunes.apple.com/ru/app/amb/id1124487701?mt=8',
                pc: 'https://yamb.yandex.ru/desktop/download?platform=${platform}',
            },
            mail: {
                android: 'https://play.google.com/store/apps/details?id=ru.yandex.mail',
                ios: 'https://itunes.apple.com/ru/app/yandex.mail/id441785419',
            },
            disk: {
                android: 'https://play.google.com/store/apps/details?id=ru.yandex.disk',
                ios: 'https://itunes.apple.com/ru/app/andeks.disk/id553266487',
                pc: 'https://disk.yandex.ru/download/#pc',
            },
            tracker: {
                android: 'https://play.google.com/store/apps/details?id=ru.yandex.tracker',
                ios: 'https://itunes.apple.com/ru/app/яндекс-трекер/id1351761680?mt=8',
            },
            browser: {
                pc: 'https://browser.yandex.ru/constructor/?utm_source=connect&utm_medium=home',
            },
        },

        help: {
            main: 'https://yandex.${tld}/support/connect/',
            dkim: 'https://yandex.ru/support/connect/dns/dkim.html',
            domains: 'https://yandex.ru/support/connect/domains.html',
            domain_confirmation: 'https://yandex.ru/support/pdd/setting/confirm.html',
            wiki: {
                details: 'https://yandex.ru/support/connect-wiki/index.html',
            },
            tracker: {
                details: 'https://connect.yandex.ru/tracker?noredirect=1',
                pricing: 'https://yandex.ru/tracker/pricing',
                licenses: 'https://yandex.ru/support/connect/billing.html#billing__section_jyb_gdv_1cb',
                subscription_email: 'tracker@yandex-team.ru',
                settings: 'https://yandex.ru/support/connect-tracker/enable-tracker.html',
            },
            subscription: {
                default: 'https://connect.yandex.ru/pricing',
            },
            user_agreement: 'https://yandex.ru/legal/rules/',
            partner_user_agreement: 'https://yandex.ru/legal/client_rules_connect/',
            privacy_policy: 'https://yandex.ru/legal/confidential/',
            license_agreement: 'https://yandex.ru/legal/connect_software_agreement/',
            billing: 'https://yandex.ru/support/connect/billing.html',
            billing_acts: 'https://balance.yandex.ru/acts.xml',
            balance_main: 'https://balance.yandex.ru/',
            offer: 'https://yandex.ru/legal/oferta_connect/',
            service_request: 'https://forms.yandex.ru/surveys/4795/',
            restore_feedback: 'https://forms.yandex.ru/surveys/10011606/',
            troubleshooting: 'https://yandex.ru/support/connect/troubleshooting.html',
            feedback: 'https://yandex.ru/support/connect/feedback.html',
            about: '/?noredirect=1',
            bind: {
                advantages: {
                    default: '/?noredirect=1',
                    metrika: '/metrika?noredirect=1&utm_source=metrica&utm_medium=interface&utm_campaign=yaconnect&utm_content=widget_link',
                },
                faq: {
                    default: '/faq?noredirect=1',
                    metrika: 'https://yandex.ru/support/connect/metrica.html',
                },
                more: {
                    default: '/?noredirect=1',
                    metrika: '/metrika?noredirect=1&utm_source=metrica&utm_medium=interface&utm_campaign=yaconnect&utm_content=widget_beta',
                },
                subscribe: {
                    metrika: 'https://forms.yandex.ru/surveys/10015270/?utm_source=metrica&utm_medium=interface&utm_campaign=yaconnect&utm_content=widget_beta',
                },
            },
            dns_editor: 'https://yandex.ru/support/connect/dns-editor.html',
            delegate_domain: 'https://yandex.ru/support/connect/delegate-domain.html',
            mx: 'https://yandex.ru/support/connect/dns/mx.html',

            reorg: 'https://yandex.ru/support/connect/reorg.html',
            metricsTagAccess: 'https://yandex.ru/support/connect/metrics.html#metrica__tag-access',
            metricsDetachTag: 'https://yandex.ru/support/connect/metrics.html#metrica__detach-tag',
            metrikaGeneralAccess: 'https://yandex.ru/support/metrica/general/access.html',
        },

        about: {
            connect: 'https://yandex.ru/support/connect/pricing.html#pricing__section_ob3_cpq_ybb',
            tracker: 'https://yandex.ru/support/connect/pricing.html#pricing__section_k5j_npq_ybb',
            wiki: 'https://connect.yandex.ru/wiki?noredirect=1',
            disk: 'https://connect.yandex.ru/disk?noredirect=1',
            mail: 'https://connect.yandex.ru/mail?noredirect=1',
            forms: 'https://yandex.ru/support/connect-forms/',
        },

        avatar: {
            host: 'https://avatars.mds.yandex.net',
            url: 'https://avatars.mds.yandex.net/get-yapic/${id}/islands-${size}',
            minOriginalSize: 200,
        },

        cloud: {
            org: 'https://org-preprod.cloud.yandex.ru/',
            orgCreate: 'https://org-preprod.cloud.yandex.ru/create',
            promo: {
                wiki: 'https://cloud.yandex.ru/services/wiki',
                forms: 'https://cloud.yandex.ru/services/forms',
                tracker: 'https://cloud.yandex.ru/services/tracker',
            },
        },

        metrika_counters: 'https://metrika.yandex.ru/list',
        forbidden: 'https://${host}/portal/forbidden?reason=${reason}&source=${source}&retpath=${retpath}',
        search: 'https://${host}/search/directory?text=${query}&org_id=${org_id}',
        logo: 'https://yastatic.net/q/logoaas/v1/${text}.svg',
        email: 'https://mail.yandex.ru/compose?to=${email}',
        privateYambChat: 'https://api.messenger.yandex.ru/user/${nickname}',
        staff: 'https://staff.yandex.ru/${nickname}?org_id=${org_id}&uid=${uid}',
        automigrationSurvey: 'https://forms.yandex.ru/surveys/8943/',
        news_mail_subscription: '/forms/news-mail-subscription',
        promo: 'https://yandex.ru/ws/',
        mainPage: '/',
        rootPage: 'https://yandex.ru/',

        staffModeEnabled: true,
        showSubscriptionForm: true,
    },
    landing: {
        connect: '/?noredirect',
        tracker: 'https://yandex.ru/tracker/',
        forms: 'https://yandex.ru/forms/',
        wiki: '/wiki?noredirect',
        disk: '/disk?noredirect',
        yamb: '/messenger?noredirect',
    },
    passport: {
        host: 'https://passport.yandex.${tld}',
        accounts: 'https://api.passport.yandex.${tld}/all_accounts',
        session: {
            login: 'https://passport.yandex.ru/auth?retpath=${retpath}',
            logout: 'https://passport.yandex.ru/passport?mode=embeddedauth&action=logout&uid=${uid}&yu=${yu}&retpath=${retpath}',
            change: 'https://passport.yandex.ru/passport?mode=embeddedauth&action=change_default&uid=${uid}&yu=${yu}&retpath=${retpath}',
            add: 'https://passport.yandex.ru/auth?mode=add-user&retpath=${retpath}',
            update: 'https://passport.yandex.ru/auth/update/?retpath=${retpath}',
            passwordChange: 'https://passport.yandex.ru/passport?mode=changepass&retpath=${retpath}',
            confirmEmail: 'https://passport.yandex.ru/passport?mode=changeemails',
            approveUser: 'https://passport.yandex.ru/passport?mode=userapprove&retpath=${retpath}',
            upgradeUser: 'https://passport.yandex.${tld}/profile/upgrade?origin=connect&retpath=${retpath}',
        },
        org: {
            registration: 'https://passport.yandex.${tld}/registration/connect?origin=${origin}&retpath=${retpath}',
        },
    },
    org: {
        list: 'https://api.directory.yandex.${tld}/v6/organizations-by-session',
        add: '/portal/registration?action=add&source=${source}&preset=${preset}&retpath=${retpath}',
        invite: 'https://${host}/invites/?code=${code}',
        setup: 'https://${host}/setup/${query}',
        registration: {
            default: 'https://${host}/register${query}',
            fallback: 'https://forms.yandex.ru/surveys/4445/',
            yo: 'https://${host}/registration${query}',
        },
        services: 'https://${host}${appRoot}admin/subscription/services',
    },
    csp: {
        rules: {
            'default-src': '\'none\'',
            'object-src': '\'self\' blob:',
            'frame-src': '\'self\' forms.yandex.ru mc.yandex.md trust.yandex.ru',
            'child-src': 'forms.yandex.ru',
            'connect-src': [
                '\'self\'',
                'yastatic.net',
                'mc.yandex.ru',
                'yandex.ru',
                'mail.yandex.ru',
                'mail.yandex.com',
                'api.passport.yandex.ru',
                'api.passport.yandex.com',
                'api.directory.yandex.ru',
                'api.directory.yandex.com',
                'api.stat.yandex-team.ru',
            ].join(' '),
            'font-src': '\'self\' yastatic.net',
            'img-src': [
                '\'self\'',
                'yastatic.net',
                '*.mds.yandex.net',
                'mc.yandex.ru',
                'mc.admetrica.ru',
                'yandex.ru',
                'ext.captcha.yandex.net',
                'data:',
            ].join(' '),
            'script-src': [
                '\'self\'',
                '\'unsafe-eval\'',
                '\'unsafe-inline\'',
                'mc.yandex.ru',
                'yandex.ru',
                'yastatic.net',
                '*.mds.yandex.net',
                'resource:',
            ].join(' '),
            'style-src': '\'self\' \'unsafe-inline\' yastatic.net',
        },
        report: 'https://csp.yandex.net/csp',
    },
    experiment: {
    },
    mail: {
        mail: 'https://mail.yandex.ru',
        admin: 'https://admin.yandex.ru/mail?org_id=${org_id}&uid=${uid}',
    },
    pdd: {
        host: 'https://pdd.yandex.${tld}',
    },
    headers: {
        html: {
            'X-Content-Type-Options': 'nosniff',
            'X-XSS-Protection': '1;mode=block',
        },
        json: {
            'X-Content-Type-Options': 'nosniff',
            'X-XSS-Protection': '1;mode=block',
        },
    },
    sender: {
        newsList: {
            service: 'ya.connect',
            listId: 'WIP0F613-2N71',
        },
    },
    captchaOptions: {
        apiHost: 'api.captcha.yandex.net',
        type: 'ocr',
    },
};
