module.exports = {
    app: {
        isCorp: true,
        maintainsInternalUsersOnly: true,
    },
    api: {
        blackbox: 'https://blackbox.yandex-team.ru/blackbox',
        directory: 'https://api-internal-qa.directory.ws.yandex.net',
    },
    rum: {
        service_id: 'ru.connect.portal.internal',
    },
    ui: {
        avatar: {
            url: 'https://yamb.yandex-team.ru/avatar/${login}/${size}.jpg',
        },
        relatedServices: {
            calendar: 'https://calendar.yandex-team.ru',
            contacts: 'https://mail.yandex-team.ru/#contacts',
            mail: 'https://mail.yandex-team.ru/?uid=${uid}',
            passport: 'https://passport.yandex-team.ru',
            wiki: 'https://wiki.yandex-team.ru',
            disk: 'https://disk.yandex.ru',
            yamb: 'https://q.yandex-team.ru',
        },
        email: 'https://mail.yandex-team.ru/compose?to=${email}',
        privateYambChat: 'https://q.yandex-team.ru/user/${nickname}',
        staff: 'https://staff.yandex-team.ru/${nickname}?org_id=${org_id}&uid=${uid}',
    },
    passport: {
        session: {
            login: 'https://passport.yandex-team.ru/auth?retpath=${retpath}',
            logout: 'https://passport.yandex-team.ru/passport?mode=embeddedauth&action=logout&uid=${uid}&yu=${yu}&retpath=${retpath}', // eslint-disable-line max-len
            change: 'https://passport.yandex-team.ru/passport?mode=embeddedauth&action=change_default&uid=${uid}&yu=${yu}&retpath=${retpath}', // eslint-disable-line max-len
            add: 'https://passport.yandex-team.ru/auth?mode=add-user&retpath=${retpath}',
            update: 'https://passport.yandex-team.ru/auth/update/?retpath=${retpath}',
            passwordChange: 'https://passport.yandex-team.ru/passport?mode=changepass&retpath=${retpath}',
        },
    },
    metrika: {
        default: 37675215,
    },
    csp: {
        extra: {
            'img-src': 'yamb.yandex-team.ru',
        },
    },
};
