// config/production
// + integration-qa api.directory
// + csp frame-ancestors wildcard
module.exports = {
    api: {
        directory: 'https://api-integration-qa.directory.ws.yandex.net',
    },
    org: {
        list: 'https://api-integration-qa.directory.yandex.${tld}/v6/organizations-by-session',
    },
    rum: {
        counter_url: 'https://yandex.ru/clck/click',
    },
    ui: {
        relatedServices: {
            alice_b2b: 'https://dialogs.priemka.voicetech.yandex.ru/b2b',
            forms: 'https://forms.preprod.yandex.ru/b2b/admin/',
        },
        relatedResources: {
            metrika: 'https://metrika-test.haze.yandex.${tld}/dashboard?id=${id}',
            alice_b2b: 'https://dialogs.priemka.voicetech.yandex.ru/b2b/devices/${id}',
        },
        metrika_counters: 'https://metrika-test.haze.yandex.ru/list',
    },
    metrika: {
        default: 37732300,
        setup: 42999529,
        general: 42999529,
    },
    csp: {
        extra: {
            'img-src': 'yapic.yandex.net yapic.yandex.ru avatars.mds.yandex.net',
            'frame-ancestors': '*',
            'frame-src': '*.yandex.ru *.yandex.com',
            'connect-src': [
                'api-integration-qa.directory.yandex.ru',
                'api-integration-qa.directory.yandex.com',
            ].join(' '),
        },
    },
};
