module.exports = {
    app: {
        isStress: true,
        logLevel: 'debug',
    },
    api: {
        blackbox: 'https://pass-stress-s1.sezam.yandex.net/blackbox',
        directory: 'https://api.stress.directory.ws.yandex.ru',
        settings: 'https://settings-stress.ws.yandex.ru',
    },
    bunker: {
        api: 'http://bunker-api-dot.yandex.net/v1',
        version: 'latest',
    },
    ui: {
        avatar: {
            url: 'https://yapic-test.yandex.ru/get/${id}/islands-${size}',
        },
        relatedServices: {
            calendar: 'https://calendar.yandex.ru',
            contacts: 'https://mail.yandex.ru/#contacts',
            mail: 'https://mail.yandex.ru/?uid=${uid}',
            passport: 'https://passport-test.yandex.ru',
            wiki: 'https://wiki.yandex.ru',
            disk: 'https://disk.yandex.ru',
            yamb: 'https://yamb.yandex.ru',
        },
        privateYambChat: 'https://yamb.yandex.ru/user/${nickname}',
        staff: 'https://team.qloud.yandex.ru/${nickname}?org_id=${org_id}&uid=${uid}',
        promo: '/fakepromo',
    },
    passport: {
        session: {
            login: 'https://pass-stress-s1.sezam.yandex.net/auth?retpath=${retpath}',
            logout: 'https://pass-stress-s1.sezam.yandex.net/passport?mode=embeddedauth&action=logout&uid=${uid}&yu=${yu}&retpath=${retpath}', // eslint-disable-line max-len
            change: 'https://pass-stress-s1.sezam.yandex.net/passport?mode=embeddedauth&action=change_default&uid=${uid}&yu=${yu}&retpath=${retpath}', // eslint-disable-line max-len
            add: 'https://pass-stress-s1.sezam.yandex.net/auth?mode=add-user&retpath=${retpath}',
            update: 'https://pass-stress-s1.sezam.yandex.net/auth/update/?retpath=${retpath}',
            passwordChange: 'https://pass-stress-s1.sezam.yandex.net/passport?mode=changepass&retpath=${retpath}',
        },
    },
    metrika: {
        default: 37738550,
    },
};
