module.exports = {
    app: {
        root: '/portal/',
        assets: '/portal/static',
        freezePath: '/portal/_',
        host: 'connect.local.yandex.ru',
        url: 'https://connect.local.yandex.ru',
    },
    server: {
        port: 3456,
    },
    api: {
        blackbox: 'http://localhost:3354/portal/apiproxy/blackbox',
        tvm: 'http://localhost:3354/portal/apiproxy/tvm',
        suggest: 'http://localhost:3354/suggest',
        directory: 'http://localhost:3351',
        gendarme: 'http://localhost:3355',
        sender: 'http://localhost:3356',
        settings: 'http://localhost:3352',
        dns: 'http://localhost:3358/api/v1',
        setter: 'http://localhost:3359',
        fouras: 'http://localhost:3360',
        ya: 'https://yastatic.net', // https://github.com/mozilla/geckodriver/issues/770
    },
    bunker: {
        api: 'http://localhost:3357/v1',
        version: 'latest',
    },
    passport: {
        host: 'https://passport-test.yandex.${tld}',
        accounts: 'https://api.passport-test.yandex.${tld}/all_accounts',
        session: {
            login: 'https://passport-test.yandex.ru/auth?retpath=${retpath}',
            logout: 'https://passport-test.yandex.ru/passport?mode=embeddedauth&action=logout&uid=${uid}&yu=${yu}&retpath=${retpath}', // eslint-disable-line max-len
            change: 'https://passport-test.yandex.ru/passport?mode=embeddedauth&action=change_default&uid=${uid}&yu=${yu}&retpath=${retpath}', // eslint-disable-line max-len
            add: 'https://passport-test.yandex.ru/auth?mode=add-user&retpath=${retpath}',
            update: 'https://passport-test.yandex.ru/auth?retpath=${retpath}',
            passwordChange: 'https://passport-test.yandex.ru/passport?mode=changepass&retpath=${retpath}',
            confirmEmail: 'https://passport-test.yandex.ru/passport?mode=changeemails',
        },
        org: {
            registration: 'https://passport-test.yandex.${tld}/registration/connect?origin=${origin}&retpath=${retpath}',
        },
    },
    org: {
        list: 'https://api-test.directory.yandex.${tld}/v6/organizations-by-session',
    },
    metrika: {
        default: 37738550,
        general: 49300198,
    },
    ui: {
        avatar: {
            host: 'https://avatars.mdst.yandex.net',
            url: 'https://yastatic.net/s3/frontend/portal/_/CVern7u5.png',
        },
        relatedServices: {
            dashboard: '~/home',
            staff: '~/staff',
            portal: '~/admin',
            calendar: 'https://calendar.yandex.ru',
            contacts: 'https://mail.yandex.ru/#contacts',
            mail: 'https://mail.yandex.ru',
            passport: 'https://passport-test.yandex.ru',
            wiki: 'https://wiki.test.yandex.ru',
            tracker: 'https://tracker.test.yandex.ru',
            forms: 'https://forms.test.yandex.ru/b2b/admin/',
            disk: 'https://disk.yandex.ru',
        },
        privateYambChat: 'https://yamb-test.ws.yandex.ru/user/${nickname}',
        staff: 'https://team.test.yandex.ru/${nickname}?org_id=${org_id}&uid=${uid}',
        promo: '/fakepromo',
        staffModeEnabled: true,
        showSubscriptionForm: false,
    },
    csp: {
        extra: {
            'img-src': 'yapic-test.yandex.ru avatars.mdst.yandex.net',
            'connect-src': [
                'connect-test.ws.yandex.ru',
                'connect-test.ws.yandex.com',
                'api.passport-test.yandex.ru',
                'api.passport-test.yandex.com',
                'api-test.directory.yandex.ru',
                'api-test.directory.yandex.com',
            ].join(' '),
        },
    },
    sender: {
        newsList: {
            service: 'ya.connect',
            listId: 'OYON5K23-63U1',
        },
    },
};
