const _ = require('lodash');
const responseFilter = require('../lib/responseFilter');
const renderIndex = require('./index');
const i18n = require('../lib/i18n');

function filterLocaleDictionary(dictionary) {
    dictionary = _.pick(dictionary, [
        'bind',
    ]);

    return dictionary;
}

module.exports = (req, res, next) => {
    responseFilter.preprocessMixedResponse(req.context);

    _.merge(req.context, {
        layoutId: 'bindWidget',
        dictionary: filterLocaleDictionary(i18n.getDictionary(req)),
    });

    renderIndex(req, res, next);
};
