const _ = require('lodash');
const responseFilter = require('../lib/responseFilter');
const renderIndex = require('./index');
const i18n = require('../lib/i18n');

module.exports = (req, res, next) => {
    responseFilter.preprocessMixedResponse(req.context);

    _.merge(req.context, {
        layoutId: 'bindWidgetFakePage',
        dictionary: _.pick(i18n.getDictionary(req), [
            'common', 'common_options', 'footer',
            'related_services', 'app_menu',
        ]),
    });

    renderIndex(req, res, next);
};
