const _ = require('lodash');
const i18n = require('../lib/i18n');
const responseFilter = require('../lib/responseFilter');
const renderIndex = require('./index');

function filterLocaleDictionary(dictionary) {
    dictionary = _.pick(dictionary, [
        'common', 'footer', 'backend_errors', 'common_options',
        'app_menu', 'related_services', 'registration', 'invites',
    ]);

    dictionary.common = _.omit(dictionary.common, [
        'action', 'status', 'suggest_search_placeholder',
    ]);

    return dictionary;
}

module.exports = (req, res, next) => {
    responseFilter.preprocessMixedResponse(req.context);

    _.merge(req.context, {
        layoutId: 'invites',
        dictionary: filterLocaleDictionary(i18n.getDictionary(req)),
    });

    renderIndex(req, res, next);
};
