const _ = require('lodash');
const i18n = require('../lib/i18n');
const responseFilter = require('../lib/responseFilter');
const responseContext = require('../lib/responseContext');
const renderIndex = require('./index');

function filterLocaleDictionary(dictionary) {
    dictionary = _.pick(dictionary, [
        'common', 'footer', 'backend_errors', 'common_options', 'app_menu', 'related_services', 'registration',
    ]);

    dictionary.common = _.omit(dictionary.common, [
        'status', 'suggest_search_placeholder',
    ]);

    return dictionary;
}

module.exports = (req, res, next) => {
    responseFilter.preprocessMixedResponse(req.context);

    const config = req.config;

    const isInternalUser = responseContext.isInternal(req);
    const isExternalAdmin = !isInternalUser && responseContext.isAllowed(req);

    _.merge(config.app, {
        isExternalAdmin,
    });

    _.merge(req.context, {
        layoutId: 'registration',
        dictionary: filterLocaleDictionary(i18n.getDictionary(req)),
    });

    req.config = config;

    renderIndex(req, res, next);
};
