/**
 * monkey-patch node.js `dns.lookup()`
 * Сделано чтобы брались только ipv6 адреса
 */

const dns = require('dns');
const originalDNSLookup = dns.lookup;

dns.lookup = function DNSLookupPatched(hostname, options, callback) {
    if (typeof options === 'function') {
        callback = options;
        options = {};
    }

    options.family = process.env.IPV4_ONLY ? 4 : 6;

    return originalDNSLookup.call(dns, hostname, options, callback);
};
