const _ = require('lodash');

function getProp(req, name) {
    if (req && typeof req.get === 'function') {
        return req.get(name);
    }
}

function getHeader(req, name) {
    return getProp(req, name) || _.get(req, `context.headers.${name}`);
}

function getLoggerOptions(req, extension) {
    const defaultOptions = {
        request_id: _.get(extension, 'options.headers.x-request-id') || getHeader(req, 'x-request-id'),
        debug_id: getHeader(req, 'x-debug'),
        org_id: getHeader(req, 'x-org-id'),
        login: _.get(req, 'context.session.login', ''),
        path: _.get(req, 'path'),
        url: getProp(req, 'host') + req.originalUrl,
    };

    return _.extend(defaultOptions, extension);
}

module.exports = getLoggerOptions;
