const responseContext = require('./responseContext');
const logger = require('../lib/logger');

function getLocale(req) {
    const config = req.config;
    const { acceptedLocales } = config.app;
    const { lang } = req.query;

    if (lang && acceptedLocales.includes(lang)) {
        return lang;
    }

    const locale = responseContext.getSessionLocale(req);

    return (acceptedLocales.includes(locale) ? locale : config.app.defaultLocale) || 'ru';
}

function load(name) {
    let data = {};

    try {
        data = require(`../../locales/${name}.json`);
    } catch (e) {
        logger.error(`Failed to load 'locales/${name}.json'`);
    }

    return data;
}

function getDictionary(req) {
    const locale = getLocale(req);
    const i18n = load(locale);

    if (responseContext.isSetup(req) && !i18n.countries) {
        // data source: https://github.com/umpirsky/country-list
        Object.assign(i18n, load(`countries.${locale}`));
    }

    if (responseContext.isAdminPage(req) && !i18n.timezones) {
        Object.assign(i18n, load(`timezones.${getLocale(req)}`));
    }

    // чтобы устранить рассинхронизацию локализации актуальной релизной ветки и
    // более новых пулл-реквестов, не вошедших в релиз, добавляем более старую
    // версию локализации в статичный файл, чтобы не заменять ее вручную в обновленной
    // скриптом локализации; после включения новых пулл-реквестов в релиз
    // compatibility-локализацию можно удалить
    // Object.assign(i18n, load(`${locale}.compatibility`));

    return i18n;
}

module.exports = {
    getLocale,
    getDictionary,
};
