// XSS Prevention

const CHAR_MAP = {
    '&': '\\x26',
    '<': '\\x3c',
    '>': '\\x3e',
    '=': '\\x3d',
    '"': '\\x22',
    '\'': '\\x27',
    '/': '\\x2f',
};

function sanitizeHtmlContent(s) {
    if (typeof s !== 'string') {
        s = JSON.stringify(s);
    }

    s = (s || '').replace(/\\/g, '\\x5c');

    Object.keys(CHAR_MAP).forEach(key => {
        s = s.replace(new RegExp(key, 'g'), CHAR_MAP[key]);
    });

    return s;
}

module.exports = sanitizeHtmlContent;
