/**
 * Точка отправки данных пользователю
 */

const _ = require('lodash');
const serialize = require('serialize-javascript');
const logger = require('../lib/logger');

module.exports = function(req, res, responseData, status) {
    status = status || 200;

    if (!_.get(responseData, 'timing')) {
        responseData.timing = _.get(req, 'context.timing', {});
    }

    responseData.status = status;

    logger.info('Send response', req, { responseData, status });

    res.set('Content-Type', 'application/json; charset=utf-8');

    res.status(status).send(serialize(responseData, { isJSON: true }));
};
