const _ = require('lodash');
const config = require('../config');

/**
 * Устанавливает заголовки для ответа
 * @param {Request} req
 * @param {Response} res
 * @param {Object} extraHeaders
 */
module.exports = function(req, res, extraHeaders = {}) {
    const uid = _.get(req, 'context.auth.x-uid');
    const requestId = _.get(req, 'context.headers.x-request-id');
    const requestType = req.accepts(['html', 'json']) || 'html';
    const headers = _.extend(extraHeaders, _.get(config, `headers.${requestType}`, {}));

    if (requestId) {
        res.set('x-request-id', requestId);
    }

    if (uid) {
        res.set('x-uid', uid);
    }

    if (!res.get('Content-Type')) {
        res.set('Content-Type', 'text/html; charset=utf-8');
    }

    res.set(headers);
};
