// @see DIR-2226
// monkey patch встроенного dns.lookup()
// чтобы получать только ipv6-адреса

const dns = require('dns');
const _lookup = dns.lookup;

dns.lookup = (hostname, options, callback) => {
    if (typeof options === 'function') {
        callback = options;
        options = {};
    }

    options.family = process.env.IPV4_ONLY ? 4 : 6;

    return _lookup.call(dns, hostname, options, callback);
};
