const getLanguage = require('../lib2/getLanguage');
const getUserIp = require('../lib2/getUserIp');
const getUrl = require('../lib2/getUrl');

module.exports = req => {
    let headers = {
        'x-request-id': req.ctx.requestId,
        'x-request-referer': req.get('referer'),
        'x-request-url': getUrl(req),
        'Accept-Language': getLanguage(req),
        'Content-Type': req.get('Content-Type'),
        'x-uid': req.get('x-uid') || (req.blackbox && req.blackbox.uid),
        'x-org-id': req.get('x-org-id') || req.ctx.orgId,
        'x-user-ip': getUserIp(req),
        'x-client-version': req.get('x-client-version'),
    };

    if (headers['x-uid'] === undefined) {
        delete headers['x-uid'];
    }

    if (headers['x-org-id'] === undefined) {
        delete headers['x-org-id'];
    }

    if (req.is('multipart')) {
        // для автодетектции заголовка с boundary
        delete headers['Content-Type'];
    }

    return headers;
};
