const _get = require('lodash/get');
const getDuration = require('./getDuration');

module.exports = req => {
    let headers = {
        'x-request-id': req.ctx.requestId,
        'x-server-version': _get(req.config, 'app.version'),
        'x-duration': getDuration(req.ctx.startTime),
    };

    if (req.accepts('html')) {
        headers = {
            ...headers,
            ..._get(req.config, 'headers.html', {}),
        };
    }

    if (req.accepts('json')) {
        headers = {
            ...headers,
            ..._get(req.config, 'headers.json', {}),
        };
    }

    return headers;
};
