const NoPayloadMethods = ['GET', 'HEAD'];

module.exports = req => {
    if (NoPayloadMethods.includes(req.method)) {
        return;
    }

    if (req.is('json')) {
        // @see DIR-9699
        if (req.body && req.body._encoded !== undefined) {
            return Buffer.from(req.body._encoded, 'base64').toString();
        }

        return JSON.stringify(req.body);
    }

    return req.body;
};
