module.exports = function getLanguage(req) {
    let { config: { app: { acceptedLocales, defaultLocale } } } = req;
    let lang = req.query.lang || (req.blackbox && req.blackbox.lang);

    if (!lang || !acceptedLocales.includes(lang)) {
        return defaultLocale || 'ru';
    }

    return lang;
};
