const Bundle = {
    BASIC: 'vendor.basic.js',
    ADVANCED: null,
};

module.exports = req => {
    if (!req.accepts('html')) {
        return;
    }

    if (!req.uatraits) {
        return Bundle.BASIC;
    }

    let { BrowserName, BrowserVersion } = req.uatraits;
    let major = BrowserVersion ? Number(BrowserVersion.split('.').slice(0, 2).join('.')) : 0;

    // max version - Promise.finally()

    if (BrowserName === 'YandexBrowser' && major >= 20) {
        return Bundle.ADVANCED;
    }

    if ((BrowserName === 'Chrome' || BrowserName === 'ChromeMobile') && major >= 63) {
        return Bundle.ADVANCED;
    }

    if ((BrowserName === 'Firefox' || BrowserName === 'MobileFirefox') && major >= 58) {
        return Bundle.ADVANCED;
    }

    if ((BrowserName === 'Opera' || BrowserName === 'OperaMobile') && major >= 50) {
        return Bundle.ADVANCED;
    }

    if (BrowserName === 'Safari' && major >= 11.1) {
        return Bundle.ADVANCED;
    }

    if (BrowserName === 'MobileSafari' && major >= 11.3) {
        return Bundle.ADVANCED;
    }

    if (BrowserName === 'Edge' && major >= 18) {
        return Bundle.ADVANCED;
    }

    return Bundle.BASIC;
};
