const get = require('lodash/get');

module.exports = (req, experimentId) => {
    const { yandexuid } = req.cookies;
    const audiencePercentage = Number(get(req.config, ['experiment', experimentId, 'percentage']));

    if (Number.isNaN(audiencePercentage) || (!yandexuid && audiencePercentage !== 100)) {
        return false;
    }

    const selected = Number(yandexuid.slice(-2)) < audiencePercentage;
    const off = ['decline', 'off'].includes(req.cookies[`connect_experiment_${experimentId}`]);

    return selected && !off;
};
