// https://wiki.yandex-team.ru/security/awareness/skarif/policy/
const MaskedCookies = [
    'Session_id',
    'sessionid2',
];

const MASK = '***';

function maskCookies(cookieHeader) {
    if (!cookieHeader) {
        return cookieHeader;
    }

    return cookieHeader
        .split(/\s*;\s*/)
        .map(part => {
            let [key, value] = part.split('=');

            if (MaskedCookies.includes(key)) {
                value = `${value.substring(0, 12)}${MASK}`;
            }

            return `${key}=${value}`;
        })
        .join('; ');
}

module.exports = maskCookies;
