const { URL } = require('url');
const getUrl = require('./getUrl');

function fixRetpath(req, retpath) {
    if (!retpath) {
        return retpath;
    }

    if (/^\/\//.test(retpath)) {
        retpath = `https:${retpath}`;
    }

    // если retpath относительный, сделаем его абсолютным
    return new URL(retpath, getUrl(req)).href;
}

// @see https://wiki.yandex-team.ru/cookies/y/
function setYCookie(req, res, { retpath, ...params }) {
    let url = new URL('/portal/set/any/', req.config.api.ya);

    for (let [key, value] of Object.entries(params)) {
        url.searchParams.set(key, value);
    }

    retpath = fixRetpath(req, retpath);

    if (retpath) {
        url.searchParams.set('retpath', retpath);
    } else {
        url.searchParams.set('empty', 1);
    }

    // eslint-disable-next-line no-console
    console.log('Set y-cookie', {
        requestId: req.ctx.requestId,
        uid: req.blackbox && req.blackbox.uid,
        redirectUrl: url.href,
        currentUrl: getUrl(req),
    });

    res.redirect(url.href);
}

module.exports = setYCookie;
