const getUser = require('../lib2/getUser');
const isInternalAccount = require('../lib2/isInternalAccount');
const directory = require('../api2/directory');

// @see DIR-5959 + DIR-5906
module.exports = () => (req, res, next) => {
    let user = getUser(req, 'raw');

    if (isInternalAccount(user)) {
        return next();
    }

    directory(req)
        .send('GET', '/v11/users/type/')
        .then(res => res.json())
        .then(({ internal }) => {
            if (internal) {
                if (!user.attributes) {
                    user.attributes = {};
                }

                user.attributes['1011'] = '1';
            }

            next();
        })
        .catch(() => {
            next();
        });
};
