const redirectToForbidden = require('../lib2/redirectToForbidden');

module.exports = () => (req, res, next) => {
    const { role } = req.ctx.user || {};

    if (role !== 'admin' && role !== 'deputy_admin') {
        return redirectToForbidden(req, res, {
            logMsg: 'Redirect to forbidden (checkAdminRole): user is not admin',
            logParams: {
                userRole: role,
            },
        });
    }

    return next();
};
