const getHostName = require('../lib2/getHostName');

// @see DIR-2184
module.exports = () => (req, res, next) => {
    let host = getHostName(req);
    let tld = host.split('.').pop();
    let [envSuffix = ''] = host.split('.').shift().match(/-\S+$/) || [];

    if (host === `portal${envSuffix}.ws.yandex.${tld}`) {
        return res.redirect(`https://connect${envSuffix}.yandex.${tld}${req.originalUrl}`);
    }

    next();
};
