const fetch = require('../lib2/fetch');
const patchFetchUrl = require('../lib2/patchFetchUrl');

module.exports = blackboxConfig => (req, res, next) => {
    let { proxyUrl } = blackboxConfig;
    let proxyOptions = {
        headers: {
            Cookie: req.get('Cookie'),
        },
    };

    fetch(patchFetchUrl(req, proxyUrl).href, proxyOptions)
        .then(res => res.ok ? res.json() : { error: res.statusText })
        .then(data => {
            req.blackbox = data;

            next();
        });
};
