const _merge = require('lodash/merge');
const directory = require('../api2/directory');

module.exports = () => (req, res, next) => {
    let { orgId } = req.ctx;

    if (!orgId) {
        return next();
    }

    directory(req)
        .send('GET', `/v11/organizations/${orgId}/features/`)
        .then(res => res.json())
        .then(data => {
            req.ctx.features = _merge(req.ctx.features, data);

            next();
        })
        .catch(() => {
            next();
        });
};
