const getRandomString = require('@connect/random-string');
const config = require('../config');

module.exports = () => (req, res, next) => {
    req.ctx = {
        startTime: process.hrtime(),
        requestId: req.get('x-request-id') || getRandomString(16),
    };

    req.config = config.setup(req);
    req.ctx.features = req.config.features;

    // eslint-disable-next-line no-console
    console.log(`Initiating request ${req.method} ${req.path}`, {
        'x-uid': req.get('x-uid'),
        'x-org-id': req.get('x-org-id'),
        'x-request-url': req.get('x-request-url'),
        requestId: req.ctx.requestId,
        originalUrl: req.originalUrl,
        method: req.method,
        path: req.path,
    });

    next();
};
