const _get = require('lodash/get');
const buildUrl = require('@connect/url-placeholders');
const getUrl = require('../lib2/getUrl');

// @see https://doc.yandex-team.ru/Passport/passport-modes/reference/admkarma.html
const Karma = {
    NORMAL: 0,
    SUSPECTED_SPAMMER: 85,
    SPAMMER: 100,
};

module.exports = () => (req, res, next) => {
    let { uid, karma } = req.blackbox;

    if (karma === Karma.SPAMMER) {
        let currentUrl = getUrl(req);
        let redirectUrl = buildUrl(_get(req.config, 'passport.session.approveUser'), {
            retpath: currentUrl,
        });

        // eslint-disable-next-line no-console
        console.log('Approve account: bad karma', {
            requestId: req.ctx.requestId,
            uid,
            karma,
            currentUrl,
            redirectUrl,
        });

        return res.redirect(redirectUrl);
    }

    if (karma === Karma.SUSPECTED_SPAMMER) {
        req.ctx.showCaptcha = true;
    }

    next();
};
