const getBasicResponseHeaders = require('../lib2/getBasicResponseHeaders');
const ValidStatuses = ['VALID', 'NEED_RESET'];

module.exports = () => (req, res, next) => {
    let { tvm, blackbox } = req;

    if (!tvm || !blackbox || !ValidStatuses.includes(blackbox.status)) {
        return res
            .status(401)
            .set(getBasicResponseHeaders(req))
            .json({
                errorCode: 401,
                message: blackbox && blackbox.error,
                status: blackbox && blackbox.status,
            });
    }

    next();
};
