module.exports = () => (req, res, next) => {
    if (!req.context.headers) {
        req.context.headers = {};
    }

    const xOrgId = req.get('x-org-id');

    if (xOrgId) {
        req.context.headers['x-org-id'] = xOrgId;
    }

    const xDebug = req.get('x-debug') || (req.query ? req.query.debug : null);

    if (xDebug) {
        req.context.headers['x-debug'] = xDebug;
    }

    const isFirstLoad = req.get('x-first-visit');

    if (isFirstLoad) {
        req.context.headers['x-database'] = 'master';
    }

    req.context.headers['x-request-id'] = req.context.requestId;

    next();
};
