const directory = require('../api2/directory');

const fields = [
    'name',
];

module.exports = ({ orgFields = [] } = {}) => (req, res, next) => {
    directory(req, { 'X-DISABLE-CLOUD-PROXY': 'true' })
        .send('GET', '/v11/organizations/', {
            query: {
                fields: fields.concat(orgFields).join(','),
                per_page: 1000,
            },
        })
        .then(res => res.json())
        .then(data => {
            req.ctx.orgs = data.result;

            next();
        })
        .catch(() => {
            next();
        });
};
