const directory = require('../api2/directory');

module.exports = () => (req, res, next) => {
    let { orgId } = req.ctx;

    if (!orgId) {
        return next();
    }

    directory(req)
        .send('GET', '/v11/permissions/')
        .then(res => res.json())
        .then(data => {
            req.ctx.permissions = {
                global: data,
            };

            next();
        })
        .catch(() => {
            next();
        });
};
