const getBasicResponseHeaders = require('../lib2/getBasicResponseHeaders');

module.exports = prop => (req, res) => {
    res.set(getBasicResponseHeaders(req));

    if (!req[prop]) {
        return res.status(500).json({
            code: `no_${prop}_data`,
        });
    }

    let { error } = req[prop];

    if (error && error !== 'OK') {
        return res.status(400).json({
            code: `${prop}_error`,
            body: error,
        });
    }

    return res.json(req[prop]);
};
