const _get = require('lodash/get');
const directory = require('../api2/directory');
const getLanguage = require('../lib2/getLanguage');

module.exports = () => (req, res, next) => {
    directory(req)
        .send('GET', '/v11/ui/services/', {
            query: {
                language: getLanguage(req),
                tld: _get(req.config, 'app.tld'),
            }
        })
        .then(res => res.json())
        .then(data => {
            req.ctx.services = data;

            next();
        })
        .catch(() => {
            next();
        });
};
