const _get = require('lodash/get');
const _pick = require('lodash/pick');
const getLanguage = require('../lib2/getLanguage');
const getTexts = require('../lib2/getTexts');

module.exports = () => (req, res, next) => {
    if (!req.accepts('html') || req.query.iframe === '1' || !req.uatraits || req.path === '/portal/setup') {
        return next();
    }

    let { BrowserName, BrowserVersion, isMobile } = req.uatraits;
    let isOldIE = BrowserName === 'MSIE' && BrowserVersion && Number(BrowserVersion.split('.').shift()) < 11;

    if (isOldIE || (isMobile && req.cookies.mobile_warning_visited !== 'yes')) {
        let texts = getTexts(req);

        return res.render('unsupported_browser', {
            title: _get(texts, 'common.full_main_title', 'Yandex.Connect'),
            i18n: _pick(texts, ['common', 'museum']),
            locale: getLanguage(req),
            isMobile,
            staticDir: _get(req.config, 'app.assets'),
        });
    }

    next();
};
