let compiler;

function getCompiler() {
    if (compiler) {
        return compiler;
    }

    const webpack = require('webpack');
    const webpackConfig = require('../../webpack.config');

    return compiler = webpack(webpackConfig);
}

module.exports = () => [
    require('webpack-dev-middleware')(getCompiler(), {
        logLevel: 'warn',
        publicPath: '/portal/static/',
    }),
    require('webpack-hot-middleware')(getCompiler()),
];
