/**
 * Добавляет данные об админах
 */

const _ = require('lodash');
const responseContext = require('../lib/responseContext');
const groupApi = require('../routes/api/extendedGroup');

const ADMINS_GROUP_TYPE = 'organization_admin';

module.exports = function(req, res, next) {
    const isInternalUser = responseContext.isInternal(req);

    if (isInternalUser) {
        const originalQuery = _.clone(req.query);

        req.query = {
            type: ADMINS_GROUP_TYPE,
            per_page: _.get(req.config, 'directory.perPage.groups'),
        };

        return groupApi.read(req, res)
            .then(() => {
                req.query = originalQuery;

                next();
            })
            .catch(() => next());
    }

    next();
};
