const expressBunker = require('@yandex-int/express-bunker');

module.exports = [
    function(req, res, next) {
        if (req.config.app.env === 'ui-test' && !req.cookies.__bunker__) {
            return;
        }

        expressBunker(req.config.bunker)(req, res, next);
    },
    function(req, res, next) {
        if (!req.bunker) {
            next({
                errorCode: 500,
                code: 'bunker_get_error',
            });

            return;
        }

        res.json({ bunker: req.bunker });
    },
];
