const _ = require('lodash');
const expressCaptcha = require('@yandex-int/express-captcha');
const i18n = require('../lib/i18n');

module.exports = [
    function(req, res, next) {
        if (!req.context.isCaptchaRequired) {
            return next();
        }

        expressCaptcha.check(_.assign({ vtype: i18n.getLocale(req) }, req.config.captchaOptions))(req, res, next);
    },

    function(req, res, next) {
        if (_.get(req, 'captcha.error')) {
            next({
                errorCode: 422,
                code: 'captcha_validation_error',
            });

            return;
        }

        req.body = _.omit(req.body, ['key', 'rep']);

        next();
    },
];
